#include "main.h"

void draw_insanity_meter();
void draw_health();
void do_powerups();
int logic();

list<_powerup> powerups;

int logic()
{
	static bool first = true;
	static int timer = 0;
	static unsigned int time = 0;
	char c[40];
	int a;
	
	if (first)
	{
		play_sample(sweird, 255, 128, 1000, 1);
		timer = 0;
		time = 0;
		level = 1;
		enemies.clear();
		eshot.clear();
		particles.clear();
		first = false;
	}
	
	time++;
	if (time >= 3600)
	{
		level++;
		sprintf(c, "Level %d", level);
		new_particle(P_TEXT, 320, 240, 0, -0.5, c);
		time = 0;
	}
	sprintf(c, "Next Level In %d:%02d", ((3600 - time) / 50) / 60, ((3600 - time) / 50) % 60);
	buffer_textout_right_ex(font, c, 640, 5, WHITE);
	sprintf(c, "Score: %d", score);
	buffer_textout_right_ex(font, c, 640, 15, WHITE);
	sprintf(c, "High Score: %d", highscore);
	buffer_textout_right_ex(font, c, 640, 25, WHITE);

	do_particles();
	draw_insanity_meter();
	draw_health();
	do_powerups();
	player.do_stuff();
	do_enemies();
	
	switch(level)
	{
		case 1:
			if (rand()%40 == 0)
			{
				new_enemy(ECIRCLE);
			}
			break;
		case 2:
			if (rand()%50 == 0)
			{
				new_enemy(ECIRCLE);
			}
			if (rand()%70 == 0)
			{
				new_enemy(ESHIP);
			}
			break;
		case 3:
			if (rand()%70 == 0)
			{
				new_enemy_group(ECIRCLE, 3, 35);
			}
			if (rand()%50 == 0)
			{
				new_enemy(ESHIP);
			}
			break;
		case 4:
			if (rand()%70 == 0)
			{
				new_enemy(ESAUCER);
			}
			if (rand()%60 == 0)
			{
				new_enemy(ESHIP);
			}
			if (rand()%150 == 0)
			{
				new_enemy_group(ECIRCLE, 5, 15);
			}
			break;
		case 5:
			if (rand()%70 == 0)
			{
				new_enemy(ESAUCER);
			}
			if (rand()%100 == 0)
			{
				new_enemy_group(ESHIP, 3, 10);
			}
			if (rand()%50 == 0)
			{
				new_enemy(ECIRCLE);
			}
			break;
		default:
			if (rand()%60 == 0)
			{
				new_enemy(ESAUCER);
			}
			if (rand()%120 == 0)
			{
				new_enemy_group(ESHIP, 5, 10);
			}
			if (rand()%80 == 0)
			{
				new_enemy(ESHIP);
			}
			if (rand()%180 == 0)
			{
				new_enemy_group(ECIRCLE, 5, 15);
			}
			break;
	}
	
	if (player.insane)
	{
		timer--;
		sprintf(c, "%d:%02d", (timer / 50) / 60, (timer / 50) % 60);
		buffer_textout_centre_ex(font, c, 50, 12, WHITE);
		if (timer <= 0)
		{
			player.craziness = 0;
			player.insane = false;
			timer = 0;
		}
		
		if (rand()%500 == 0)
		{
			a = rand()%2;
			play_sample(smoo, 255, 128, 1000, 0);
			if (a == 0)
			{
				new_particle(P_COW, -20, 100 + rand()%300, 10, -10);
			}
			else
			{
				new_particle(P_COW, 660, 100 + rand()%300, -10, -10);
			}
		}
	}
	else
	{
		new_particle(P_STAR, rand()%640, 0, 0, 1 + float(rand()%100) / 10.0);
		if (player.craziness > 0)
		{
			timer++;
			if (timer > 50)
			{
				player.craziness--;
				timer = 0;
			}
		}
		if (player.craziness >= 100)
		{
			player.insane = true;
			player.craziness = 100;
			player.timesinsane++;
			timer = 750 * player.timesinsane;  //15 seconds * timesinsane
			play_sample(sgonenuts, 255, 128, 1000, 0);
		}
	}
	
	if (key[KEY_ESC])
	{
		first = true;
		player.init(false);
		stop_sample(sweird);
		particles.clear();
		return MENU;
	}
	
	if (player.health <= 0)
	{
		first = true;
		stop_sample(sweird);
		return DEAD;
	}
	
	return LOGIC;
}

void draw_insanity_meter()
{
	static int redness = 0;
	buffer_draw_sprite(insanity, 5, 0);
	buffer_rect(5, 10, 105, 20, WHITE);
	if (player.insane)
	{
		buffer_rectfill(6, 11, 104, 19, makecol(redness, 0, 0));
		redness += 5;
		if (redness > 255) redness = 0;
	}
	else
	{		
		buffer_rectfill(6, 11, 4 + player.craziness, 19, RED);
	}
}

void draw_health()
{
	buffer_draw_sprite(health, 5, 20);
	buffer_rect(5, 30, 105, 40, WHITE);
	buffer_rectfill(6, 31, 4 + player.health, 39, BLUE);
}

void do_powerups()
{
	_powerup p;
	list<_powerup>::iterator it;
	
	if (rand()%400 == 0)
	{
		p.type = rand()%2;
		p.x = 10 + rand()%620;
		p.y = -20;
		p.yv = 4 + rand()%9;
		powerups.push_back(p);
	}
	
	it = powerups.begin();
	while (it != powerups.end())
	{
		(*it).y += (*it).yv;
		if ((*it).type == SHOT_PLUS)
		{
			if (player.insane)
			{
				buffer_draw_sprite(shotminus, int((*it).x), int((*it).y));
			}
			else
			{
				buffer_draw_sprite(shotplus, int((*it).x), int((*it).y));
			}
		}
		else
		{
			if (player.insane)
			{
				buffer_draw_sprite(shotplus, int((*it).x), int((*it).y));
			}
			else
			{
				buffer_draw_sprite(shotminus, int((*it).x), int((*it).y));
			}
		}
		
		if (((*it).x + 20 > player.x) && ((*it).x < player.x + 25))
		{
			if (((*it).y + 20 > player.y) && ((*it).y < player.y + 25))
			{
				if ((*it).type == SHOT_PLUS)
				{
					player.shotmode++;
					if (player.shotmode > SHOT_SPREAD) player.shotmode = SHOT_SPREAD;
				}
				else
				{
					player.shotmode--;
					if (player.shotmode < SHOT_NORMAL) player.shotmode = SHOT_NORMAL;
				}
				powerups.erase(it);
				it--;
			}
		}
		it++;
	}
}
